/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.CompositeStepVO;
import com.quantumdata.sct.dao.vo.InputStepVO;
import com.quantumdata.sct.dao.vo.OptionStepVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.test.TestEngine;
import com.quantumdata.sct.gui.wizard.TestStepsPage;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TestPage {
    private Vector stepPages = new Vector();
    private int currentStepPageIndex;
    private TestEngine testEngine;

    TestPage(TestVO testVO) throws Exception {
        this.testEngine = new TestEngine(testVO);
        this.stepPages.add(this.createTestSetupPage(testVO));
        this.prepareStepPages(testVO.getStepsVO());
        this.stepPages.add(this.testEngine.createTestConcludePage());
    }

    void resetTestPage() {
        for (int i = 0; i < this.stepPages.size() - 1; ++i) {
            Object e = this.stepPages.get(i);
            if (!(e instanceof TestStepsPage)) continue;
            TestStepsPage testStepsPage = (TestStepsPage)e;
            testStepsPage.setExecuted(false);
        }
        this.currentStepPageIndex = 0;
    }

    void prepareStepPages(AbstractStepVO[] abstractStepVOArray) throws Exception {
        TestStepsPage testStepsPage = null;
        for (int i = 0; i < abstractStepVOArray.length; ++i) {
            if (abstractStepVOArray[i] instanceof CompositeStepVO) {
                CompositeStepVO compositeStepVO = (CompositeStepVO)abstractStepVOArray[i];
                if (compositeStepVO.isSetupStep()) {
                    testStepsPage = new TestStepsPage(this.testEngine);
                    testStepsPage.addSetupStep(compositeStepVO);
                    this.stepPages.add(testStepsPage);
                    testStepsPage = null;
                }
                ArrayList arrayList = compositeStepVO.getChildStepsList();
                int n = 0;
                AbstractStepVO[] abstractStepVOArray2 = new AbstractStepVO[arrayList.size()];
                Iterator iterator = compositeStepVO.getChildStepsList().iterator();
                while (iterator.hasNext()) {
                    abstractStepVOArray2[n++] = (AbstractStepVO)iterator.next();
                }
                this.prepareStepPages(abstractStepVOArray2);
                continue;
            }
            if (abstractStepVOArray[i] instanceof InputStepVO || abstractStepVOArray[i] instanceof OptionStepVO) {
                if (testStepsPage == null) {
                    testStepsPage = new TestStepsPage(this.testEngine);
                    this.stepPages.add(testStepsPage);
                }
                testStepsPage.addStep(abstractStepVOArray[i]);
                testStepsPage = null;
                continue;
            }
            if (testStepsPage == null) {
                testStepsPage = new TestStepsPage(this.testEngine);
                this.stepPages.add(testStepsPage);
            }
            testStepsPage.addStep(abstractStepVOArray[i]);
        }
    }

    public JPanel createTestSetupPage(TestVO testVO) {
        ImageIcon imageIcon;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.white);
        SCTSelection.instance();
        jPanel.add((Component)SCTSelection.getTestHeader(testVO), "North");
        if (testVO.getImageRef() != null && (imageIcon = new ImageIcon(testVO.getImageRef())) != null) {
            jPanel.add((Component)new JLabel(imageIcon), "Center");
        }
        jPanel.setName("Test Setup");
        return jPanel;
    }

    public boolean isFirstStep() {
        return this.currentStepPageIndex == 0;
    }

    public boolean isLastStep() {
        return this.currentStepPageIndex == this.stepPages.size() - 1;
    }

    public void nextButtonAction(ActionEvent actionEvent) {
        Object e = this.stepPages.get(this.currentStepPageIndex);
        if (e instanceof TestStepsPage) {
            TestStepsPage testStepsPage = (TestStepsPage)e;
            if (!testStepsPage.executePage()) {
                return;
            }
            if (this.currentStepPageIndex == this.stepPages.size() - 2) {
                try {
                    this.testEngine.saveTestResult();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (this.currentStepPageIndex < this.stepPages.size() - 1) {
            ++this.currentStepPageIndex;
        }
        e = this.stepPages.get(this.currentStepPageIndex);
    }

    public void backButtonAction(ActionEvent actionEvent) {
        if (this.currentStepPageIndex > 0) {
            --this.currentStepPageIndex;
        }
    }

    public JPanel getDisplayPanel() {
        Object e = this.stepPages.get(this.currentStepPageIndex);
        if (e instanceof TestStepsPage) {
            return ((TestStepsPage)e).getDisplayPanel();
        }
        return (JPanel)e;
    }

    public boolean isUserFound() {
        Object e = this.stepPages.get(this.currentStepPageIndex);
        if (e instanceof TestStepsPage) {
            return ((TestStepsPage)e).isUserFound();
        }
        return false;
    }
}

